﻿<%@ Page Language="vb" AutoEventWireup="false" CodeBehind="AddMaps.aspx.vb" Inherits=".AddMaps" %>

<script src="https://maps.googleapis.com/maps/api/js?v=3.exp&signed_in=false&libraries=places"></script>

<!DOCTYPE html>

<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
    <meta name="viewport" content="initial-scale=1.0, user-scalable=no" />
    <meta charset="utf-8" />
    <style type="text/css">
        #map-canvas {
            height: 100%;
            margin: 0px;
            padding: 0px;
        }

        .controls {
            margin-top: 16px;
            border: 1px solid transparent;
            border-radius: 2px 0 0 2px;
            box-sizing: border-box;
            -moz-box-sizing: border-box;
            height: 32px;
            outline: none;
            box-shadow: 0 2px 6px rgba(0, 0, 0, 0.3);
        }

        #pac-input {
            background-color: #fff;
            font-family: Roboto;
            font-size: 15px;
            font-weight: 300;
            margin-left: 12px;
            padding: 0 11px 0 13px;
            text-overflow: ellipsis;
            width: 400px;
        }

            #pac-input:focus {
                border-color: #4d90fe;
            }

        .pac-container {
            font-family: Roboto;
        }

        #type-selector {
            color: #fff;
            background-color: #4d90fe;
            padding: 5px 11px 0px 11px;
        }

            #type-selector label {
                font-family: Roboto;
                font-size: 13px;
                font-weight: 300;
            }

        #target {
            width: 345px;
        }
    </style>

 

    <title>Harita Ekle/Düzenle</title>

    <script>
    // This example adds a search box to a map, using the Google Place Autocomplete
               // feature. People can enter geographical searches. The search box will return a
               // pick list containing a mix of places and predicted search terms.

               var markers = [];
               var marker = [];
               var map;
               

               function initialize() {
                   var locxy = document.getElementById('lbl4').value;
                   var xkoor = locxy.split(',')[0];
                   var ykoor = locxy.split(',')[1];
           
                   var stockholm = new google.maps.LatLng(xkoor,ykoor);
                   var parliament = new google.maps.LatLng(xkoor, ykoor);
 
                   map = new google.maps.Map(document.getElementById('map-canvas'), {
                       mapTypeId: google.maps.MapTypeId.ROADMAP
                   });

                   marker = new google.maps.Marker({
                       map: map,
                       draggable: true,
                       animation: google.maps.Animation.DROP,
                       position: parliament
                   });

                   google.maps.event.addListener(marker, 'dragend', function () {
                       var itm = document.getElementById('lbl3');
                       itm.value = marker.getPosition();
                   });

                   var defaultBounds = new google.maps.LatLngBounds(
                       stockholm,
                       parliament);
                   map.fitBounds(defaultBounds);

                   // Create the search box and link it to the UI element.
                   var input = /** @type {HTMLInputElement} */(
                       document.getElementById('pac-input'));
                   map.controls[google.maps.ControlPosition.TOP_LEFT].push(input);

                   var searchBox = new google.maps.places.SearchBox(
                     /** @type {HTMLInputElement} */(input));

                   // [START region_getplaces]
                   // Listen for the event fired when the user selects an item from the
                   // pick list. Retrieve the matching places for that item.
                   google.maps.event.addListener(searchBox, 'places_changed', function () {
                       deleteMarkers();
                       var places = searchBox.getPlaces();

                       if (places.length == 0) {
                           return;
                       }
                       for (var i = 0, marker; marker = markers[i]; i++) {
                           marker.setMap(null);
                       }
                    
                       // For each place, get the icon, place name, and location.
                       markers = [];
                       var bounds = new google.maps.LatLngBounds();
                       for (var i = 0, place; place = places[i]; i++) {
                           var image = {
                               url: place.icon,
                               size: new google.maps.Size(71, 71),
                               origin: new google.maps.Point(0, 0),
                               anchor: new google.maps.Point(17, 34),
                               scaledSize: new google.maps.Size(25, 25)
                           };

                           // Create a marker for each place.
                           var marker = new google.maps.Marker({
                               map: map,
                               draggable: true,
                               icon: image,
                               title: place.name,
                               animation: google.maps.Animation.DROP,
                               position: place.geometry.location
                           });

                           markers.push(marker);

                           google.maps.event.addListener(marker, 'dragend', function () {
                               var itm = document.getElementById('lbl3');
                               itm.value = marker.getPosition();                           
                           });

                           bounds.extend(place.geometry.location);
                       }

                       map.fitBounds(bounds);
                   });
                   // [END region_getplaces]

                   // Bias the SearchBox results towards places that are within the bounds of the
                   // current map's viewport.
                   google.maps.event.addListener(map, 'bounds_changed', function () {
                       var bounds = map.getBounds();
                       searchBox.setBounds(bounds);
                      
                   });

               }


               function deleteMarkers() {
                   marker.setMap(null);
               }

               google.maps.event.addDomListener(window, 'load', initialize);



               </script>

</head>
<body>
    <form id="form1" runat="server">   
        <div>
            <div class="buttonGroup">
                        <asp:Button ID="btnSaveExit" runat="server" CssClass="btnDefault" Text="Kapat"></asp:Button>
                        <asp:Button ID="btnCancel" runat="server" CausesValidation="False" CssClass="btnDefault" Text="İptal"></asp:Button>
                    </div>
            <input id="pac-input" class="controls" onkeypress="if (event.keyCode == 13) deleteMarkers();" type="text" placeholder="İl,İlçe,Semt,Mahalle" />
            <input onclick="deleteMarkers();" hidden="hidden" type="button" value="Delete Markers"/>
            <asp:Label runat="server" ID="lbl2"></asp:Label>
             <input id="lbl3" type="hidden" name="Hidden1" runat="server">
            <input id="lbl4" type="hidden" name="Hidden2" runat="server">

            <div id="map-canvas"></div>      
            </div>    
    </form>
</body>
</html>
