﻿<%@ Page Language="vb" AutoEventWireup="false" Inherits="ASPNetPortal.ShoppingCartImages" CodeBehind="ShoppingCartImages.aspx.vb" %>

<%@ Import Namespace="System" %>
<%@ Import Namespace="ASPNetPortal" %>
<div>
	<asp:datagrid id="MyList" runat="server" autogeneratecolumns="False" width="100%" cellpadding="4" datakeyfield="Qty" cssclass="datalist" gridlines="none">
                <Columns>
                    <asp:TemplateColumn Visible="False">
                        <ItemTemplate>
                            <asp:Label ID="ProductID" runat="server" Text='<%# DataBinder.Eval(Container.DataItem, "ProductID") %>' Visible="False">
                            </asp:Label>
                            <asp:Label ID="RecordID" runat="server" Text='<%# DataBinder.Eval(Container.DataItem, "RecordId") %>' Visible="False">
                            </asp:Label>
                            <asp:Label ID="Attributes" Visible="false" runat="server" Text='<%# container.dataitem("Attributes").tostring  %>'></asp:Label>
                        </ItemTemplate>
                        <HeaderStyle Width="0px" />
                    </asp:TemplateColumn>
                    <asp:TemplateColumn HeaderText="">
                        <ItemTemplate>
                            <asp:Image ID="Image3" runat="server" BorderStyle="None" ImageUrl='<%#urlbase & "/store/makethumb.aspx?file=" + Container.DataItem("Path") + "&intSize=50"%>' oncontextmenu="return false" />
                        </ItemTemplate>
                    </asp:TemplateColumn>
                    <asp:TemplateColumn HeaderText="">
                        <ItemTemplate>
                            <itemstyle wrap="False"></itemstyle>
                            <asp:HyperLink ID="ProductName" runat="server" NavigateUrl='<%# string.format(BaseUrl & "{0}" & ".aspx",container.dataitem("Url").tostring.Remove(container.dataitem("Url").tostring.Length - 1, 1)) %>' Text='<%# container.dataitem("ProductName") %>'>
                            </asp:HyperLink>
                            <asp:Label ID="ProductDescription" runat="server" Text='<%# container.dataitem("Description")  %>'></asp:Label>
                        </ItemTemplate>
                    </asp:TemplateColumn>
                    <asp:TemplateColumn HeaderText="">
                        <ItemTemplate>
                            <asp:TextBox runat="server" ID="Quantity" Text='<%# DataBinder.Eval(Container.DataItem, "Qty")%>' Visible="false" />
                            <asp:Label ID="Label18" runat="server" Text='<%# formatNumberEx( DataBinder.Eval(Container.DataItem, "Qty")) & " " & Container.DataItem("BirimAdi")%>'>
                            </asp:Label>
                        </ItemTemplate>
                    </asp:TemplateColumn>
                    <asp:TemplateColumn HeaderText="">
                        <ItemTemplate>
                            <asp:Label Visible='<%# SeePrice()%>' ID="pricewithtax" runat="server" Text='<%# CurrencySymbolLeft & " " & formatCurDoviz(((container.dataitem("SatisFiyati")*container.dataitem("Rate")) + Container.DataItem("ValueAdd")) / CurrencyRate  * Container.DataItem("Qty") ) & "  " & CurrencySymbolRight %>'>
                            </asp:Label>
                        </ItemTemplate>
                    </asp:TemplateColumn>
                </Columns>
            </asp:datagrid>
	<div class="cartDetail">
		<%If SeePrice() Then%>
		<span class="cartPriceTitle"><%=GetGlobalResourceObject("lang", "TotalPrice")%>:</span><asp:label id="totalprice" runat="server" />
		<%End If%>
		<a href="/store/cart.aspx" class="button"><%=GetGlobalResourceObject("lang", "Buy")%></a>
	</div>

</div>

<script language="vb" runat="server">

	Dim con As New DatabaseDB
	Public UserIndirim As Decimal
	Public ToplamTutar As Decimal = 0
	Dim StokIskActive As Boolean
	Dim StokIsk As Integer
	Dim cartId As String
	Dim urlbase As String = ""

	Protected Sub Page_Load(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.Load
         
		If ConfigurationManager.AppSettings("UseSsl") = "True" Then
			urlbase = BaseUrl.Replace("http://", "https://")
		Else
			urlbase = BaseUrl
                      
		End If

		Dim ua As New UsersDB
		If HttpContext.Current.User.Identity.IsAuthenticated() Then
			cartId = Context.User.Identity.Name.Split("|")(0)
			If IsNumeric(cartId) Then
				Dim dr As SqlDataReader
				dr = ua.GetUserIndirim(cartId)
				dr.Read()
				UserIndirim = dr(0)
				StokIskActive = ChkNullBoolean(dr(1))
				StokIsk = dr(2)
				dr.Close()
			Else
				' cartId = -1
				UserIndirim = 0
				StokIskActive = False
				StokIsk = 0
			End If
		Else
			cartId = GetShoppingCartId()
			UserIndirim = 0
			StokIskActive = False
		End If

		Dim cart As ShoppingCartDB = New ShoppingCartDB
		 
		Dim dt_cart As DataTable = cart.GetItemsForCart(cartId, 0, StokIsk, StokIskActive, 0, DefaultLangCode)
		For Each drt As DataRow In dt_cart.Rows
			ToplamTutar += CalcKdvDahil(CalcIndirim(CalcIndirim(CalcRate(((drt("SatisFiyati") + drt("ValueAdd")) * drt("qty")) + drt("ValueAddNoQty"), drt("Rate")), drt("Indirim")), UserIndirim), drt("KdvRate"))
		Next
		MyList.DataSource = dt_cart
		MyList.DataBind()
		 
		totalprice.Text = CurrencySymbolLeft & " " & formatCurDoviz(ToplamTutar / DefaultCurrencyRate / CurrencyRate) & " " & CurrencySymbolRight
        
	End Sub
      
</script>
