<%@ Page Language="vb" Inherits="System.Web.UI.Page" AutoEventWireup="false" Debug="true" %>

<%@ Import Namespace="System.Web.UI.HtmlControls" %>
<%@ Import Namespace="System.Data.SqlClient" %>
<%@ OutputCache Duration="1800" VaryByParam="LangCode" %>
<%@ Import Namespace="AspNetPortal" %>
<ul id="category_menu" class="main_menuv" runat="server"></ul>
<script language="VB" runat="server">	
    
    Protected Sub Page_Load(ByVal sender As Object, ByVal e As System.EventArgs) Handles MyBase.Load
         
        Dim urlbase As String = ""
        If ConfigurationManager.AppSettings("UseSsl") = "True" Then
            urlbase = BaseUrl.Replace("http://", "https://")
        Else
            urlbase = BaseUrl
                      
        End If
		
        Dim conn As New SqlConnection((ConfigurationManager.AppSettings("ConnStr")))
        'Dim sqlstr As String = "SELECT CategoryDescription.*,Categories.CatImg,Categories.ChildCount  FROM  CategoryDescription  INNER JOIN  Categories ON CategoryDescription.CatId=Categories.CatId " & _
        '					   "WHERE Categories.IsActive=1 and Categories.IsVisible=1 and  LanguageCode=@LangCode AND PortalId=@PortalId and Categories.Parent=0 " & _
        '					   "ORDER BY CategoryDescription.Depth ,isnull(ShowOrder,100),CategoryDescription.CatName"
        Dim daa As New SqlDataAdapter("GetCategoryForPrice", conn)
        daa.SelectCommand.CommandType = CommandType.StoredProcedure

        daa.SelectCommand.Parameters.AddWithValue("@CartId", GetShoppingCartId)
        daa.SelectCommand.Parameters.AddWithValue("@Lic", 1)
        daa.SelectCommand.Parameters.AddWithValue("@PortalId", PortalId)
        daa.SelectCommand.Parameters.AddWithValue("@CatId", -1)
        If HttpContext.Current.Session("UICulture") Is Nothing Then
            daa.SelectCommand.Parameters.AddWithValue("@LangCode", DefaultLangCode)
        Else
            daa.SelectCommand.Parameters.AddWithValue("@LangCode", ChkNullEmptyString(HttpContext.Current.Session("UICulture").ToString.Split("-")(0)))
        End If

        Dim dtcat As New DataTable
        'cmd.Fill(dtcat)
        daa.Fill(dtcat)
 
        conn.Open()
	 
        For Each dr As DataRow In dtcat.Rows
            
            'balk
            Dim catName As String = dr("CatName")
            Dim catLink As String = urlbase & dr("CatUrl").ToString.Replace("/kategori/", UseV3SeoCategoryWord).Remove(dr("CatUrl").ToString.Replace("/kategori/", UseV3SeoCategoryWord).Length - 1, 1) & ".aspx" & IIf(Request.QueryString("tabId") <> "", "?tabId=" & Request.QueryString("tabId"), "")

            Try
                Dim li As New HtmlGenericControl("li")
                li.Attributes.Add("runat", "server")
                li.ID = "li_" & dr("CatId")
                li.Attributes.Add("class", "item")
                'seili ise
                If Not Request.QueryString("CatId") Is Nothing Then
                    If Request.QueryString("CatId") = dr("CatId") Then
                        li.Attributes.Add("class", "selected")
                    End If
                End If

                li.InnerHtml = String.Format("<a href=""{1}"">{0}</a>", catName, catLink)
                category_menu.Controls.Add(li)
            Catch
            End Try

       
        Next
        conn.Close()
		
    End Sub

</script>
<%--
kullanm
<script>
$.ajax({
url: "http://www.proticaretg5d.com/services/categoryserviceparent.aspx?LangCode=",
context: document.body,
success: function(data){
$("#menu_top2").html(data);
}
});
</script>
<div id="menu_top2"></div>--%>