﻿<%@ WebHandler Language="VB" Class="Product" %>

Imports System
Imports System.Web
Imports System.Web.Script.Serialization
Imports System.Collections.Generic
Imports System.Web.UI.WebControls
Imports System.Web.UI

Public Class Product : Implements IHttpHandler, System.Web.SessionState.IReadOnlySessionState
    
	Public Sub ProcessRequest(ByVal context As HttpContext) Implements IHttpHandler.ProcessRequest
		
		Dim conf As New AppConfig
		Dim time As Integer = 0
		
		If System.Configuration.ConfigurationManager.AppSettings("CacheVitrin") IsNot Nothing Then
			If IsNumeric(conf.GetValue("CacheVitrin", GetType(Integer))) Then
				time = conf.GetValue("CacheVitrin", GetType(Integer))
			End If
		End If
		Dim page As New OutputCachedPage(New OutputCacheParameters() With { _
		  .Duration = time, _
		  .Location = OutputCacheLocation.Server, _
		  .VaryByParam = "CatId;LangCode;MarkId;CompanyId;auth;pub" _
	  })

		page.ProcessRequest(HttpContext.Current)

		
		context.Response.ContentType = "application/json"
		context.Response.BufferOutput = True
 
 
		If Not HttpContext.Current.Request.Headers("X-Requested-With") Is Nothing And HttpContext.Current.Request.Headers("X-Requested-With") = "XMLHttpRequest" Then
			Dim cc As Integer = 0
			If IsNumeric(context.Request("CatId")) Then
				cc = context.Request("CatId")
			End If
			Dim m As Integer = 0
			If IsNumeric(context.Request("MarkId")) Then
				m = context.Request("MarkId")
			End If
			Dim a As Integer = 0
			If IsNumeric(context.Request("auth")) Then
				a = context.Request("auth")
			End If
			Dim p As Integer = 0
			If IsNumeric(context.Request("pub")) Then
				p = context.Request("pub")
			End If
			Dim com As Integer = 0
			If IsNumeric(context.Request("CompanyId")) Then
				com = context.Request("CompanyId")
			End If
			Dim result As String = GetProducts(cc, m, com, p, a) 
			context.Response.ContentType = "application/json"
			context.Response.Write(result)
		Else
			context.Response.ContentType = "application/json"
			context.Response.Write("{""Message"":""Authorization has been denied for this request.""}")
		End If
			
 
		
	End Sub
 
	Public Class Categories
		Public CatId As Integer
		Public CatName As String
		Public CatUrl As String
		Public CatImg As String
		Public Parent As Integer
	End Class
 
	Public Class Products
		Public ProductId As Integer
		Public ShopId As Integer
		Public ProductCode As String
		Public ProductName As String
		Public StockQty As Decimal
		Public SatisFiyati As Decimal
		Public CurrencyName As String
		Public CurrencyRight As String
		Public CurrencyLeft As String
		Public CatId As Integer
		Public ShowOrder As Integer
		Public Review As Integer
		Public KdvRate As Decimal
		Public PiyasaFiyati As Decimal
		Public CurrencyP As String
		Public RateP As Decimal
		Public ImageDesc As String
		Public MarKName As String
		Public ProductUrl As String
		Public Path As String
		Public Url2 As String
		Public HizliKargo As Boolean
		Public EnUcuzUrun As Boolean
		Public AyniGunTeslim As Boolean
		Public OzelUrun As Boolean
		Public IndirimliUrun As Boolean
		Public SinirliSayidaUrun As Boolean
		Public FirsatUrunu As Boolean
		Public YeniUrun As Boolean
		Public SokFiyatliUrun As Boolean
		Public HediyeliUrun As Boolean
		Public Indirim As Decimal
		Public Code14 As String
		Public Code15 As String
		Public ShopNickName As String
		Public Size As New List(Of SizeDetail)
	End Class
	
	
	Public Class SizeDetail
		Public Size0Id As Integer
		Public Size1Id As Integer
		Public Size2Id As Integer
	End Class
 
	Public Shared constr As New DatabaseDB
	
	
	Private NotInheritable Class OutputCachedPage
		Inherits Page
		Private _cacheSettings As OutputCacheParameters

		Public Sub New(cacheSettings As OutputCacheParameters)
			' Tracing requires Page IDs to be unique.
			ID = Guid.NewGuid().ToString()
			_cacheSettings = cacheSettings
		End Sub

		Protected Overrides Sub FrameworkInitialize()
			MyBase.FrameworkInitialize()
			InitOutputCache(_cacheSettings)
		End Sub
	End Class
	
	
	
	Public Shared Function GetProducts(ByVal CatId As Integer, ByVal MarkId As Integer, ByVal CompanyId As Integer, ByVal pub As Integer, ByVal auth As Integer) As String
		 
		  
		Using cmd As New SqlDataAdapter("ProductListHomeC2C", constr.conn)
			Dim customers As New List(Of Products)()
			cmd.SelectCommand.CommandType = CommandType.StoredProcedure

			cmd.SelectCommand.Parameters.AddWithValue("@CartId", GetShoppingCartId)
			cmd.SelectCommand.Parameters.AddWithValue("@StokIndirim", 0)
			cmd.SelectCommand.Parameters.AddWithValue("@CatId", CatId)
			cmd.SelectCommand.Parameters.AddWithValue("@MarkId", MarkId)
			cmd.SelectCommand.Parameters.AddWithValue("@auth", auth)
			cmd.SelectCommand.Parameters.AddWithValue("@pub", pub)
			cmd.SelectCommand.Parameters.AddWithValue("@StokIskActive", 0)
			cmd.SelectCommand.Parameters.AddWithValue("@UserIndirim", 0)
			cmd.SelectCommand.Parameters.AddWithValue("@CompanyId", CompanyId)
			If HttpContext.Current.Session("UICulture") Is Nothing Then
				cmd.SelectCommand.Parameters.AddWithValue("@LangCode", DefaultLangCode)
			Else
				cmd.SelectCommand.Parameters.AddWithValue("@LangCode", ChkNullEmptyString(HttpContext.Current.Session("UICulture").ToString.Split("-")(0)))
			End If

			constr.connectDb()

			Dim dt As New DataTable
			Dim dt2 As New DataTable
			cmd.Fill(dt)
			Dim PDSource As New PagedDataSource
			PDSource.DataSource = Distinct(dt, "ProductId").DefaultView
			dt2 = DirectCast(PDSource.DataSource, System.Data.DataView).Table
			dt2.DefaultView.Sort = "ShowOrder,ProductId desc"
		
			
			For Each sdr As DataRow In dt2.Rows
				customers.Add(New Products() With { _
					  .ProductId = sdr("ProductId").ToString(), _
					  .ShopId = sdr("ShopId").ToString(), _
					  .ProductCode = sdr("ProductCode").ToString(), _
					  .ProductName = sdr("ProductName").ToString(), _
					  .StockQty = sdr("StockQty").ToString(), _
					  .SatisFiyati = formatCurDoviz(CalcKdvDahil(sdr("SatisFiyati") * sdr("Rate"), sdr("KdvRate")) / DefaultCurrencyRate), _
					  .CurrencyName = sdr("CurrencyName").ToString(), _
					  .CurrencyRight = CurrencySymbolRight, _
					  .CurrencyLeft = CurrencySymbolLeft, _
					  .CatId = sdr("CatId"), _
					  .ShowOrder = sdr("ShowOrder"), _
					  .Review = sdr("Review"), _
					  .KdvRate = sdr("KdvRate").ToString(), _
					  .PiyasaFiyati = formatCurDoviz(sdr("PiyasaFiyati")), _
					  .CurrencyP = sdr("CurrencyP").ToString(), _
					  .RateP = sdr("RateP").ToString(), _
					  .ImageDesc = sdr("ImageDesc").ToString(), _
					  .MarKName = sdr("MarKName").ToString(), _
					  .ProductUrl = sdr("ProductUrl").ToString().Remove(sdr("ProductUrl").ToString().Length - 1, 1).Replace("/urun/", UseV3SeoProductWord) & UseV3SeoExtension,
					  .Path = sdr("Path").ToString(), _
					  .Url2 = sdr("Url2").ToString(), _
					  .HizliKargo = sdr("HizliKargo").ToString(), _
					  .EnUcuzUrun = sdr("EnUcuzUrun").ToString(), _
					  .AyniGunTeslim = sdr("AyniGunTeslim").ToString(), _
					  .OzelUrun = sdr("OzelUrun").ToString(), _
					  .IndirimliUrun = IIf(sdr("PiyasaFiyati") > sdr("SatisFiyati"), sdr("IndirimliUrun").ToString(), False), _
					  .SinirliSayidaUrun = sdr("SinirliSayidaUrun").ToString(), _
					  .FirsatUrunu = sdr("FirsatUrunu").ToString(), _
					  .YeniUrun = sdr("YeniUrun").ToString(), _
					  .SokFiyatliUrun = sdr("SokFiyatliUrun").ToString(), _
					  .HediyeliUrun = sdr("HediyeliUrun").ToString(), _
					  .Indirim = CInt(GetPercent(ChkNullToDecimal(sdr("PiyasaFiyati")), ChkNullToDecimal(sdr("SatisFiyati")))), _
					  .Code14 = sdr("Code14").ToString(), _
					  .Code15 = sdr("Code15").ToString(), _
					  .ShopNickName = sdr("ShopNickName").ToString(), _
					  .Size = GetSizeOfProduct(sdr("ProductId"), sdr("ProductSizeOptionId"))
				})
			Next

			constr.disconnectDb()

			Dim mySerializer As New JavaScriptSerializer()
			mySerializer.MaxJsonLength = 20971520
			Dim result As String = mySerializer.Serialize(customers)
 


			Return result
		End Using
		
		
	End Function
	
	Public Shared Function GetSizeOfProduct(ByVal ProductId As Integer, ByVal SizeId As Integer) As List(Of SizeDetail)
		
		Dim sizelist As New List(Of SizeDetail)
		
		
		If SizeId > 0 Then
			Dim cmd As New SqlCommand("select ProductSize0ValueId,ProductSize1ValueId,ProductSize2ValueId from ProductSizes where ProductId=@ProductId", constr.conn)
			cmd.Parameters.AddWithValue("@ProductId", ProductId)
			Dim dr As SqlDataReader = cmd.ExecuteReader
			 
			While dr.Read
				sizelist.Add(New SizeDetail() With { _
					.Size0Id = ChkNullInteger(dr("ProductSize0ValueId")), _
					.Size1Id = ChkNullInteger(dr("ProductSize1ValueId")), _
					.Size2Id = ChkNullInteger(dr("ProductSize2ValueId"))
					})
							  
							  
			End While
			
			
		Else
			sizelist.Add(New SizeDetail() With { _
				 .Size0Id = 0, _
				 .Size1Id = 0, _
				 .Size2Id = 0
				 })
			Return sizelist
		End If
		
		Return sizelist
				
	End Function
	
	Public Shared Function Distinct(ByVal dt As DataTable, ByVal DistinctColumn As String) As DataTable
		
		Dim dtclone As DataTable = dt.Clone
		Dim dv As New DataView(dt)
		dtclone.PrimaryKey = New DataColumn() {dtclone.Columns(DistinctColumn)}
		Dim SelOld As String = ""
		For i As Integer = 0 To dv.Count - 1
			If SelOld <> dv(i)(DistinctColumn).ToString Then
				Dim drn As DataRow = dtclone.NewRow
				For y As Integer = 0 To drn.ItemArray.Length - 1
					drn(y) = dv(i)(y)
				Next
				SelOld = dv(i)(DistinctColumn).ToString
				Try
					dtclone.Rows.Add(drn)
				Catch
				End Try

			Else

			End If
		Next
		Return dtclone
	End Function
	
    
	Public ReadOnly Property IsReusable() As Boolean Implements IHttpHandler.IsReusable
		Get
			Return False
		End Get
	End Property

End Class