<%@ WebService Language="VB" Class="ASPNetPortal.specialcode" %>
Imports System.Web
Imports System.Web.Services
Imports System.Web.Services.Protocols
Imports System.Xml
Imports System.Web.Script.Services
Imports System

Imports System.Net
Imports System.Text
Imports System.IO
Imports AjaxControlToolkit
Imports System.Data.SqlClient
'Imports System.Security.Cryptography
Imports System.Collections.Generic
Imports System.Collections.Specialized

Namespace ASPNetPortal
    <WebService(Namespace:="http://tempuri.org/")> _
<WebServiceBinding(ConformsTo:=WsiProfiles.BasicProfile1_1)> _
<ScriptService()> _
    Public Class specialcode
        
        Inherits System.Web.Services.WebService
        
      
        <WebMethod()> Public Function GetCountry(ByVal knownCategoryValues As String, ByVal category As String) As CascadingDropDownNameValue()

            Dim values As New List(Of CascadingDropDownNameValue)()
       
            Dim cnn As New DatabaseDB
            Dim cmd As New SqlClient.SqlCommand("SELECT DISTINCT Code1 FROM Products WHERE IsActive=1 AND Code1<>'' ORDER BY Code1 ASC ", cnn.conn)
            cnn.connectDb()
            Dim dr As SqlDataReader
            dr = cmd.ExecuteReader

            While dr.Read()
                Dim CountryName As String = CType(dr("Code1"), String)
                Dim CountryId As String = CType(dr("Code1"), String)
                values.Add(New CascadingDropDownNameValue(CountryName, CountryId.ToString))
            End While
            dr.Close()
            cnn.disconnectDb()
            
            Return values.ToArray

        End Function
    
        <WebMethod()> Public Function GetCity(ByVal knownCategoryValues As String, ByVal category As String) As CascadingDropDownNameValue()

            Dim kv As StringDictionary = CascadingDropDown.ParseKnownCategoryValuesString(knownCategoryValues)
            'Dim makeId As Integer
            If (Not kv.ContainsKey("CountryId")) Then
                Return Nothing
            End If
            Dim values As New List(Of CascadingDropDownNameValue)()
             
            
            Dim cnn As New DatabaseDB
            Dim cmd As New SqlClient.SqlCommand("SELECT DISTINCT Code2 FROM Products WHERE IsActive=1 AND Code1=@CountryId  AND Code2<>'' ORDER BY Code2 ASC ", cnn.conn)
            cmd.Parameters.AddWithValue("@CountryId", kv("CountryId"))
            cnn.connectDb()
            Dim dr As SqlDataReader
            dr = cmd.ExecuteReader

            While dr.Read
                Dim CityName As String = CType(dr("Code2"), String)
                Dim CityId As String = CType(dr("Code2") & "|" & kv("CountryId"), String)
                values.Add(New CascadingDropDownNameValue(CityName, CityId.ToString))
            End While
            dr.Close()
            cnn.disconnectDb()
            
            Return values.ToArray

        End Function

        <WebMethod()> Public Function GetDistict(ByVal knownCategoryValues As String, ByVal category As String) As CascadingDropDownNameValue()

            Dim kv As StringDictionary = CascadingDropDown.ParseKnownCategoryValuesString(knownCategoryValues)
            'Dim makeId As Integer
            If (Not kv.ContainsKey("CityId")) Then
                Return Nothing
            End If
            Dim values As New List(Of CascadingDropDownNameValue)()
             
            
            Dim cnn As New DatabaseDB
            Dim cmd As New SqlClient.SqlCommand("SELECT DISTINCT Code3 FROM Products WHERE IsActive=1 AND Code2=@CityId  AND Code1=@CityId2  AND Code3<>'' ORDER BY Code3 ASC  ", cnn.conn)
            cmd.Parameters.AddWithValue("@CityId", kv("CityId").Split("|")(0))
            cmd.Parameters.AddWithValue("@CityId2", kv("CityId").Split("|")(1))
            cnn.connectDb()
            Dim dr As SqlDataReader
            dr = cmd.ExecuteReader

            While dr.Read
                Dim DistrictName As String = CType(dr("Code3"), String)
                Dim DistrictId As String = CType(dr("Code3"), String)
                values.Add(New CascadingDropDownNameValue(DistrictName, DistrictId.ToString))
            End While
            dr.Close()
            cnn.disconnectDb()
            
            Return values.ToArray

        End Function


    End Class

End Namespace