"user strict"

$.fn.pager = function (opt) {
	opt = opt || {};
	var optionList = $.extend({}, $.fn.pager.defaultOptionList, opt);

	//page related
	this.url = optionList.url;
	this.startRow = optionList.startRow;
	this.pageLen = optionList.pageLen;
	this.rawList = [];
	this.filteredList = [];
	this.pagedList = [];
	this.filterFunctionList = {};
	this.cmpFunction = false; //compare function
	var self = this;

	////clear expired cache items
	//var interval = 60000; //millisecond
	//setInterval(function () {
	//	console.log("deleting cache.");
	//	var len = sessionStorage.length;
	//	for (var i = 0; i < len; i++) {
	//		var key = sessionStorage.key(i);

	//		var now = Math.floor(Date.now());
	//		var cacheTime = JSON.parse(sessionStorage.getItem(key)).timeStamp;
	//		console.log(now, cacheTime);
	//		if (Math.floor(Date.now()) - JSON.parse(sessionStorage.getItem(key)).timeStamp > interval) {
	//			sessionStorage.removeItem(key);
	//		}
	//	}
	//}, interval);

	//var tmp = sessionStorage.getItem(self.url);
	//if (tmp !== null) {
	//	tmp = JSON.parse(tmp);
	//	console.log("displaying from cache.");
	//	self.rawList = tmp.data;
	//	self.trigger("ready");
	//} else {

	$.getJSON(self.url, function (data) {

		//var tmp = { timeStamp: Math.floor(Date.now()), data: data };
		//sessionStorage.setItem(self.url, JSON.stringify(tmp));
		self.rawList = data;
	}).done(function () {
		self.trigger("ready");
	}).fail(function (jqxhr, textStatus, error) {
		var err = textStatus + ", " + error;
		console.log("Request Failed: " + err);
	});

	self.render = function (pn) {
		self.filteredList = [];
		var len = self.rawList.length;
		for (var i = 0; i < len; i++)
			self.filteredList.push(self.rawList[i]);

		for (var key in self.filterFunctionList) {
			var buf = [];

			self.filteredList.forEach(function (row) {
				if (self.filterFunctionList[key](row))
					buf.push(row)
			});

			self.filteredList = buf;
		}

		if (self.cmpFunction)
			self.filteredList.sort(self.cmpFunction);

		self.defaultFilter(pn);
	}

	self.defaultFilter = function (pn) {
		if (pn === undefined)
			pn = 1;

		pn = self.touchPageNo(pn);
		self.startRow = (pn - 1) * self.pageLen;
		if (self.startRow < 0)
			self.startRow = 0;
		if (self.startRow > self.filteredList.length)
			self.startRow = self.filteredList.length - self.pageLen;

		var buf = [];
		var endRow = self.startRow + self.pageLen;
		if (endRow > self.filteredList.length)
			endRow = self.filteredList.length;

		for (var i = self.startRow; i < endRow; i++) {
			buf.push(self.filteredList[i]);
		}

		self.pagedList = buf;
	}

	self.addFilter = function (filterName, func) {
		if (arguments.length !== 2)
			throw new Error("wrong number of arguments in addFilter function.");

		if (self.filterFunctionList[filterName] !== undefined)
			throw new Error("filter name already exists.");

		self.filterFunctionList[filterName] = func;
	}

	self.clearAllFilter = function () {
		self.filterFunctionList = {};
	}

	self.clearFilterByName = function (filterName) {
		delete self.filterFunctionList[filterName];
	}

	self.addCmpFunction = function (func) {
		//func takes three parameters; field, type, order
		self.cmpFunction = func;
	}

	self.getMaxPrice = function (arr, prop) {
		if (self.isEmpty())
			return 0;
		var max;
		for (var i = 0 ; i < arr.length ; i++) {
			if (!max || parseInt(arr[i][prop]) > parseInt(max[prop]))
				max = arr[i];
		}
		return max[prop];
	}

	self.getCurrency = function (arr, prop) {
		if (self.isEmpty())
			return 'TL';
		var max;


		return arr[0][prop];
	}

	self.clearCmpFunction = function () {
		delete self.cmpFunction;
	}

	self.isEmpty = function () {
		if (self.filteredList.length === 0)
			return true;

		return false;
	}

	self.totalRow = function () {
		return self.filteredList.length;
	}

	self.touchPageNo = function (pageNo) {
		var totalPage = Math.ceil(self.totalRow() / self.pageLen)
		if (pageNo < 1)
			return 1;

		if (pageNo > totalPage)
			return totalPage;

		return pageNo;
	}

	return this;
};

$.fn.pager.defaultOptionList = {
	"url": "",
	"startRow": 0,
	"pageLen": 10,
}
