<%@ Control Language="vb" AutoEventWireup="false" Inherits="ASPNetPortal.PortalModuleControl" EnableViewState="False" %>
<%@ Import Namespace="System.Data.SqlClient" %>

<script src="<% =getThemePath() %>/js/proslider/owl.carousel.js" type="text/javascript"></script>

<div class="module ten-products">
    <% If HeaderVisible Then%>
    <div class="moduleTitle">
        <%=ModuleTitle%>
        <% If IsEditable Then%>
        <a href="<%=EditNavigateUrl %>" class="moduleTitleEdit"><%=EditText %></a>
        <% End If%>
    </div>
    <% End If%>
    <div class="moduleContent">
        <asp:Repeater ID="dlCatTopProducts" runat="server">
            <HeaderTemplate>
                <div id="owl-ten-products">
            </HeaderTemplate>

            <ItemTemplate>
                <div class="item clearFix">
                    <a href="<%# string.format(BaseUrl & "{0}" & ".aspx",container.dataitem("ProductUrl").tostring.Remove(container.dataitem("ProductUrl").tostring.Length - 1, 1)) %>">
                        <span class="image">
                            <img src="<%# BaseUrl & "/store/makethumb.aspx?file=" & container.dataitem("Path")%> &amp;intSize=170" /></span>
                        <span class="name"><%# container.dataitem("ProductName") %></span>
                        <% If (ConfigurationManager.AppSettings("OnlyUsersCanSeePrice") = "True" And HttpContext.Current.User.Identity.IsAuthenticated()) Or ConfigurationManager.AppSettings("OnlyUsersCanSeePrice") <> "True" Then%>
                        <% If SeePrice() Then%>
                        <div id="homelabels">
                            <div id="IndirimliUrun" style="display: <%# iif((eval("IndirimliUrun")) and (ChkNullToDecimal(Eval("PiyasaFiyati")) > 0) ,"block;","none;") %>">%<%#CInt(GetPercent(ChkNullToDecimal(Eval("PiyasaFiyati")),ChkNullToDecimal(Eval("SatisFiyati")))) %><span><%=GetGlobalResourceObject("lang", "Discount")%></span></div>
                            <div class="clear"></div>
                        </div>
                        <span class="price">
                            <span class="oldPrice" style="display: <%# iif(ChkNullToDecimal(Eval("PiyasaFiyati")) > 0,"block;","none;") %>">
                                <asp:Label ID="Label14" runat="server"><%#formatCurTL(CalcKdvDahil(Container.DataItem("PiyasaFiyati") * Container.DataItem("RateP"), Container.DataItem("KdvRate")))%></asp:Label>
                            </span>
                            <span class="productPrice"><%#formatCurDoviz(CalcKdvDahil(Container.DataItem("SatisFiyati") * Container.DataItem("Rate"), Container.DataItem("KdvRate")) / CurrencyRate)%></span>
                        </span>
                        <%End If%>
                        <% End If%>
                    </a>
                    <div class="productAdd none">
                        <a id="btnAddToCart" class="button prdct-btn" onclick='AddToCart(<%# container.dataitem("ProductId") %>)'><%=GetGlobalResourceObject("lang", "AddToCart")%></a>
                    </div>
                </div>
            </ItemTemplate>

            <FooterTemplate>
                </div>
            </FooterTemplate>
        </asp:Repeater>
        <asp:HyperLink ID="lnkAll" runat="server"></asp:HyperLink>
        <script type="text/javascript">
            $(document).ready(function () {

                $("#owl-ten-products").owlCarousel({

                    navigation: true, // Show next and prev buttons
                    slideSpeed: 300,
                    pagination: false,
                    paginationSpeed: 400,
                    singleItem: false,
                    navigationText: false,
                    autoPlay: 3000,
                    items: 1,
                    itemsDesktop: true,
                    itemsDesktopSmall: true,
                    itemsTablet: true,
                    itemsMobile: true

                });
            });
        </script>
        <script type="text/javascript">

            $(document).ready(function () {
                $("a[rel='lightbox']").colorbox({ photo: true, current: "resim {current} / {total}" });
                $(".lightbox").colorbox({ width: "600", height: "400", iframe: true, scrolling: false });

            });

            function AddToCart(pid) {

                var StorageId = 0;
                var ctype = 0;
                var untid = 0;
                $.colorbox({ href: '<%= BaseUrl & "/store/addtocartpopup.aspx?ProductId="%>' + pid + '&Unit=' + untid + '&ProductSizeId=0&Qty=1&CartType=0&ValueAdd=0&Attributes=&Description=&StorageId=' + StorageId, width: "600", height: "400", iframe: true, scrolling: false, close: '<%=GetGlobalResourceObject("lang", "close") %>' });

            }


        </script>
        <script runat="server" type="text/VB">
            Dim cnn As New DatabaseDB
            Public UserIndirim As Decimal
            Public StokIskActive As Boolean
            Public StokIsk As Integer
            Dim UserId As String
            Private Sub Page_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load
    
                EditText = GetGlobalResourceObject("admin", "Edit")
                EditUrl = "/admin/ecommerce/categories/EditCatTopProducts.aspx"
                EditWidth = 500
                EditHeight = 350
    
                If HttpContext.Current.User.Identity.IsAuthenticated() Then
                    UserId = Context.User.Identity.Name.Split("|")(0)
                    If IsNumeric(UserId) Then
                        Dim ua As New UsersDB
                        Dim dr As SqlDataReader
                        dr = ua.GetUserIndirim(UserId)
                        dr.Read()
                        UserIndirim = dr(0)
                        StokIskActive = dr(1)
                        StokIsk = dr(2)
                        dr.Close()
                    Else
                        UserId = -1
                        UserIndirim = 0
                        StokIskActive = 0
                        StokIsk = 0
                    End If
    
                Else
                    UserId = -1
                    UserIndirim = 0
                    StokIskActive = 0
                    StokIsk = 0
                End If
    
                Dim cat As New CategoriesDb
                If cat.GetCatTopMustShow(ModuleId) Then
                    If Request("CatId") = "" And Request("MarkId") = "" Then
                        LoadCategoryPageProducts()
                    Else
                        Me.Visible = False
                    End If
                Else
                    LoadCategoryPageProducts()
                End If
            End Sub
         
    
            Public Sub LoadCategoryPageProducts()
                Dim cat As New CategoriesDb
                Dim catId As Integer = cat.GetCategoryId(ModuleId)
    
                If catId > 0 Then
                    Dim caturl As String = cat.GetCategoryUrlById(catId)
                    If Not caturl = "" Then
                        lnkAll.NavigateUrl = BaseUrl & caturl.Remove(caturl.Length - 1, 1) & ".aspx"
    
                        Dim RecordsPerPage As Integer = 5
                      
                        If IsNumeric(ConfigurationManager.AppSettings("TopSellersPerPage")) Then
                            RecordsPerPage = ConfigurationManager.AppSettings("TopSellersPerPage")
                        End If
         
                        cnn.connectDb()
                        Dim tempstr As String = ""
         
                        Try
                            Dim cartId As String = GetShoppingCartId()
                            Dim ua As New UsersDB

                            If IsNumeric(cartId) Then
                                Dim cmd As New SqlCommand("select * from PriceProducts where Status=1 and StartDate <= getdate() and Enddate >= Getdate() order by ApplyOrder ", cnn.conn)
                                Dim drcmd As SqlDataReader
                                drcmd = cmd.ExecuteReader
                                If drcmd.HasRows Then
                                    While drcmd.Read
                                        Dim dt As New DataTable
                                        If drcmd("UserFilter") = "" Then
                                            dt = ua.GetUsers("UserId=" & cartId & " and Users.PortalId=" & PortalId).Tables(0)
                                        Else
                                            dt = ua.GetUsers("UserId=" & cartId & " and Users.PortalId=" & PortalId & " and " & drcmd("UserFilter")).Tables(0)
                                        End If

                                        If dt.Rows.Count > 0 Then

                                            If ChkNullString(drcmd("StokFilter")) <> "" Then

                                                tempstr &= " or ( " & drcmd("StokFilter") & " ) "
                                            End If


                                        End If

                                    End While
                                    If tempstr <> "" Then
                                        tempstr = " and (1=2 " & tempstr & " ) "
                                    End If
                                End If
                            End If

                        Catch ex As Exception

                        End Try

                        
                        Dim da As New SqlCommand("ProductListHome", cnn.conn)
                        da.CommandType = CommandType.StoredProcedure
        				
                        da.Parameters.AddWithValue("@CartId", GetShoppingCartId)
                        da.Parameters.AddWithValue("@CatId", catId)
                        da.Parameters.AddWithValue("@MarkId", Request("MarkId"))
                        da.Parameters.AddWithValue("@StokIndirim", StokIsk)
                        da.Parameters.AddWithValue("@StokIskActive", StokIskActive)
                        da.Parameters.AddWithValue("@UserIndirim", UserIndirim)
                        da.Parameters.AddWithValue("@Top", RecordsPerPage)
                        da.Parameters.AddWithValue("@Filter", tempstr.Replace("MarkId", "pl.MarkId"))
                        da.Parameters.AddWithValue("@SearchKeywords", "")
                        If Session("UICulture") Is Nothing Then
                            da.Parameters.AddWithValue("@LangCode", DefaultLangCode)
                        Else
                            da.Parameters.AddWithValue("@LangCode", ChkNullEmptyString(Session("UICulture").ToString.Split("-")(0)))
                        End If
    
                        Dim dr As SqlDataReader
                        dr = da.ExecuteReader
                        dlCatTopProducts.DataSource = dr
                        dlCatTopProducts.DataBind()
                        dr.Close()
                        cnn.disconnectDb()
                    End If
                End If
                If dlCatTopProducts.Items.Count > 0 Then
                    Me.Visible = True
                ElseIf PortalSecurity.IsInRole("Yneticiler") Then
                    Me.Visible = True
                Else
                    Me.Visible = False
                End If
            End Sub
        </script>
    </div>
</div>
